# バッチ設計書 9-Batch API Validation

## 概要

本ドキュメントは、Batch APIリソース（Job・CronJob）のバリデーションロジックの設計を記述する。

### 本バッチの処理概要

Batch API Validationは、Job・CronJobリソースの作成・更新時に実行されるバリデーションロジックを提供するパッケージである。APIサーバーのAdmission段階で呼び出され、不正なリソース定義を拒否する。

**業務上の目的・背景**：ユーザーがAPIサーバーに送信するJob・CronJobリソースの定義に不正な値が含まれていた場合、コントローラーの動作に問題が生じる。Batch API Validationは、リソース作成・更新時に型レベルでは検出できない意味的な整合性チェックを行い、不正な定義がetcdに保存されることを防ぐ。Cronスケジュール形式の検証、JobSpec/CronJobSpecフィールドの整合性チェック、ラベルセレクタの妥当性検証等を実施する。

**バッチの実行タイミング**：APIサーバーでのリソース作成・更新リクエスト時に同期的に実行される。

**主要な処理内容**：
1. ValidateJob: Job全体のバリデーション（ObjectMeta, Selector, Spec）
2. ValidateJobSpec: JobSpecのバリデーション（Parallelism, Completions, BackoffLimit等の非負値チェック）
3. validateGeneratedSelector: 自動生成セレクタの整合性検証
4. PodFailurePolicyのバリデーション（ルール数上限20、exit codesの値域チェック等）
5. SuccessPolicyのバリデーション（ルール数上限20、succeededIndexesの長さ制限64KB）
6. Indexed Jobの並列数上限チェック（maxParallelismForIndexedJob = 100,000）
7. CompletionMode整合性チェック
8. CronJobのスケジュール形式バリデーション
9. ManagedByフィールドの長さ制限（maxManagedByLength = 63）
10. Pod hostname生成可能性のDNS1123Label検証

**前後の処理との関連**：Batch API Types（No.8）の型定義に基づいてバリデーションを実施する。バリデーション通過後にBatch API Defaults（No.10）のデフォルト値設定が適用される。

**影響範囲**：Job・CronJobリソースの作成・更新API。バリデーションエラーはAPIレスポンスとしてクライアントに返却される。

## バッチ種別

API バリデーション（リクエスト時同期処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | APIリクエスト毎（同期実行） |
| 実行時刻 | 該当なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Job/CronJobリソースの作成/更新APIリクエスト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| kube-apiserver起動 | バリデーションはkube-apiserver内で実行 |

### 実行可否判定

Job/CronJobリソースの作成・更新リクエストが受信された場合に自動的に実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| job | *batch.Job | Yes | なし | バリデーション対象のJobオブジェクト |
| opts | JobValidationOptions | Yes | なし | バリデーションオプション（RequirePrefixedLabels, PodValidationOptions等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| APIリクエストボディ | Kubernetes API (batch/v1 Job or CronJob) | ユーザーが送信したリソース定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| field.ErrorList | Go構造体 | バリデーションエラーのリスト |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. ValidateJob呼び出し
   ├─ ObjectMetaバリデーション（DNS Subdomain名チェック）
   ├─ validateGeneratedSelector（セレクタ整合性）
   ├─ ValidateJobSpec（Spec全体バリデーション）
   └─ Indexed Jobのhostname検証（DNS1123Label）
2. ValidateJobSpec
   ├─ Selector必須チェック
   ├─ LabelSelector検証
   └─ validateJobSpec（内部）
3. validateJobSpec
   ├─ Parallelism/Completions/BackoffLimit非負値チェック
   ├─ ActiveDeadlineSeconds正値チェック
   ├─ CompletionMode整合性チェック
   ├─ PodFailurePolicy検証
   ├─ SuccessPolicy検証
   ├─ PodReplacementPolicy検証
   └─ PodTemplate検証
```

### フローチャート

```mermaid
flowchart TD
    A[APIリクエスト受信] --> B[ValidateJob]
    B --> C[ObjectMetaバリデーション]
    B --> D[validateGeneratedSelector]
    B --> E[ValidateJobSpec]
    E --> F[Selector検証]
    E --> G[validateJobSpec]
    G --> H[数値フィールド非負値チェック]
    G --> I[CompletionMode整合性]
    G --> J[PodFailurePolicy検証]
    G --> K[SuccessPolicy検証]
    G --> L[PodTemplate検証]
    B --> M{エラーあり?}
    M -->|Yes| N[ErrorList返却]
    M -->|No| O[バリデーション通過]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（バリデーションは純粋な入力検証であり、データベース操作を行わない）。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | field.Invalid | フィールド値が不正 | APIレスポンスでエラー返却 |
| - | field.Required | 必須フィールド未設定 | APIレスポンスでエラー返却 |
| - | field.TooLong | フィールド値が長すぎる | APIレスポンスでエラー返却 |
| - | field.NotSupported | サポートされていない値 | APIレスポンスでエラー返却 |

### リトライ仕様

該当なし（同期バリデーション）。

### 障害時対応

バリデーションエラーはAPIレスポンスの422 Unprocessable Entityとしてクライアントに返却される。

## トランザクション仕様

該当なし。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | APIリクエスト数に依存 |
| 目標処理時間 | ミリ秒以内（同期処理） |
| メモリ使用量上限 | 入力オブジェクトサイズに依存 |

## 排他制御

該当なし（ステートレスなバリデーション処理）。

## ログ出力

該当なし（バリデーションエラーはfield.ErrorListとして返却）。

## 監視・アラート

該当なし（APIサーバーのリクエストメトリクスで監視）。

## 備考

- ソースコード: `pkg/apis/batch/validation/validation.go`
- 主要定数:
  - maxParallelismForIndexedJob = 100,000
  - maxFailedIndexesForIndexedJob = 100,000
  - completionsSoftLimit = 100,000
  - parallelismLimitForHighCompletions = 10,000
  - maxPodFailurePolicyRules = 20
  - maxPodFailurePolicyOnExitCodesValues = 255
  - maxPodFailurePolicyOnPodConditionsPatterns = 20
  - maxManagedByLength = 63
  - maxJobSuccessPolicySucceededIndexesLimit = 64KB
  - maxSuccessPolicyRule = 20
- バリデーション対象: supportedPodFailurePolicyActions, supportedPodFailurePolicyOnExitCodesOperator, supportedPodReplacementPolicy
